# Understanding `assert` in Java

## 1. What is `assert`?
In Java, the `assert` statement is used to test assumptions made in the code.  
- If the boolean condition after `assert` evaluates to `true`, the program continues normally.  
- If it evaluates to `false`, the program throws an `AssertionError` (optionally with a custom message).  
- Assertions are typically enabled during testing/debugging and disabled in production.  

Example:
```java
assert (value >= 1 && value <= 10) : "Invalid value";
````

Here, the program ensures that `value` lies between 1 and 10.

---

## 2. Pre-conditions and Post-conditions

Assertions are often used to enforce **pre-conditions** and **post-conditions** in programs:

* **Pre-condition**: A condition that must hold **before** a method or block of code executes.
  Example: Input value must be between 1 and 10 before processing.

  ```java
  assert (value >= 1 && value <= 10) : "Invalid value";
  ```

* **Post-condition**: A condition that must hold **after** a method or block of code executes.
  Example: After sorting, an array must remain in non-decreasing order.

  ```java
  assert isSorted(array) : "Array not sorted correctly";
  ```

By enforcing pre- and post-conditions, `assert` helps catch programming errors early and improves code reliability.
